#include "render.h"


extern unsigned int frames;
vector cam={0,0,0};
vector camang={0,0,0};
extern HDC hDC;

float currentzoom=DEFAULT_ZOOM;
extern byte keys[256];
vector camangoffset={0};//from mouse
float anglearoundplayeroffset=0;
extern POINT	mousechange;

extern ascreenmode screen_mode;

extern q3_player sonic;
extern q3_player homer;
extern md3_model railgun;

extern atexture		*texture[MAX_TEXTURES];


int movecam(float timespan)
{
	vector centeron={0,0,0};

	cam[X]=centeron[X];
	cam[Y]=centeron[Y];
	cam[Z]=centeron[Z];

	if (keys[VK_RMB])
	{
//		currentzoom+=(float)(mousechange.y*0.08);
		currentzoom+=(float)(mousechange.y*(timespan/2));
		if (currentzoom<1) currentzoom=1;
		if (currentzoom>100) currentzoom=100;
		if (keys[VK_CONTROL])
			currentzoom=DEFAULT_ZOOM;
	}

	cam[Z]-=currentzoom;

	
	//cam[Z]+=(newz-cam[Z])*0.7f;

	float anglearoundplayer=0;

	if (keys[VK_LMB])
	{
		//camangoffset[X]-=(mousechange.x*1.25f);
		//camangoffset[Y]+=(mousechange.y*0.25f); 
		camangoffset[X]-=(mousechange.x*(10*timespan));
		camangoffset[Y]+=(mousechange.y*(1*timespan)); 
		if (keys[VK_CONTROL])
		{
			camangoffset[X]=0;
			camangoffset[Y]=0;
		}
	}


	anglearoundplayer+=camangoffset[X];

	cam[X]+=(float)cos(anglearoundplayer*VEC_DEG_TO_RAD)*(currentzoom);
	cam[Y]+=(float)sin((anglearoundplayer)*VEC_DEG_TO_RAD)*(currentzoom);


	camang[Z]=-anglearoundplayer;
	camang[Z]+=90;

	camang[X]=-54+(camangoffset[Y]);

	//cam[Z]=-7;
	//roll --> camang[Y]=camangoffset[X];

	if (camang[X]<-90) camang[X]=-90;
	if (camang[Y]<-90) camang[Y]=-90;
	if (camang[X]>0) camang[X]=0;
	if (camang[Y]>0) camang[Y]=0;


	return true;
}

void resetcamera(void)
{
	glLoadIdentity();

	glRotatef(camang[X],1,0,0);
	glRotatef(camang[Y],0,1,0);
	glRotatef(camang[Z],0,0,1);
	glTranslatef(cam[X],cam[Y],cam[Z]);  
}




int render(void)
{
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	#define TEST_SIZE (float)2.0f
/*
	int texture_n=0;
	findtexture("sonic",&texture_n);
	glBindTexture(GL_TEXTURE_2D,texture[texture_n]->data);
	glEnable(GL_TEXTURE_2D);

	glDisable(GL_LIGHTING);
	glBegin(GL_QUADS);
		glTexCoord2f(0,0);
		glVertex3f(-TEST_SIZE,-TEST_SIZE, 0.0f);

		glTexCoord2f(1,0);
		glVertex3f( TEST_SIZE,-TEST_SIZE, 0.0f);

		glTexCoord2f(1,1);
		glVertex3f( TEST_SIZE, TEST_SIZE, 0.0f);

		glTexCoord2f(0,1);
		glVertex3f(-TEST_SIZE, TEST_SIZE, 0.0f);
	glEnd();

/*
	glBegin(GL_TRIANGLES);
		glVertex3f( 0.0f, TEST_SIZE, 0.0f);
		glVertex3f(-TEST_SIZE,-TEST_SIZE, 0.0f);
		glVertex3f( TEST_SIZE,-TEST_SIZE, 0.0f);
	glEnd();
*/
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);
	glDisable(GL_LIGHTING);
	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL); 

	if (screen_mode.wireframe)
		glPolygonMode(GL_FRONT_AND_BACK,GL_LINE);

//	if (!screen_mode.lighting)
	//	glCullFace(GL_BACK);//glDisable(GL_LIGHTING);

	if (!screen_mode.textureson)
		glDisable(GL_TEXTURE_2D);

	//glDisable(GL_TEXTURE_2D);
	
	resetcamera();
	//glTranslatef(-4,-4,0);


	glEnable(GL_CULL_FACE);
	glCullFace(GL_FRONT);
	glDisable (GL_TEXTURE_2D);



	if (screen_mode.textureson)
	{

	glDisable (GL_TEXTURE_1D);
	//glEnable (GL_LINE_SMOOTH);
	glEnable( GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDepthFunc (GL_LEQUAL);
	glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
	glLineWidth (4.0f);
	glColor4f (0, 0, 0, 0.5f);
	drawq3player(&homer);
	glLineWidth (1.f);
	//glDisable (GL_LINE_SMOOTH);
	glDisable( GL_BLEND);

	}


	if (screen_mode.lighting)
	{

	glPolygonMode(GL_FRONT_AND_BACK,GL_FILL); 
	//float g_fCartoonColors[4] = { 1, 1, 0, 0.5f };
	float g_fCartoonColors[4] = { 1, 1, 1, 0.5f };
	int map_t=0;
	findtexture("1d",&map_t);
	//glColor3f(0.8,0.7,0.4);
	glColor4fv (g_fCartoonColors);
	glEnable (GL_TEXTURE_1D);
	glBindTexture(GL_TEXTURE_1D, texture[map_t]->data);
	if (screen_mode.wireframe)
		glEnable (GL_TEXTURE_2D);



	drawq3player(&homer);

	}












	frames++;
	SwapBuffers(hDC);
	return true;
}

